<?php
/* --------------------------------------------------------------
   IrelandVatIdValidator.php 2024-05-31
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\VatValidation\App\Validators;

/**
 * Class IrelandVatIdValidator
 *
 * @package Gambio\Core\VatValidation\App\Validators
 */
class IrelandVatIdValidator implements ManualVatIdValidator
{
    /**
     * @inheritDoc
     */
    public function validatedCountryIsoCode(): string
    {
        return 'ie';
    }
    
    
    /**
     * @inheritDoc
     */
    public function validateVatId(string $vatId): bool
    {
        return preg_match("/^ie[0-9][a-z0-9][0-9]{5}[a-z]$/", strtolower($vatId)) === 1
               || preg_match("/^ie[0-9]{7}[a-w][a-i]$/", strtolower($vatId)) === 1;
    }
}